package dtelements;

import java.util.ArrayList;

public class Node {

	private ArrayList<Example> examples;
	private Attribute attribute;
	private ArrayList<Node> edges;
	private ArrayList<String> edgeLabels;
	private Node parent;
	private int depth;
	private ArrayList<Attribute> remainingAttributes;

	public Node(Attribute attribute, ArrayList<Example> examples, ArrayList<Attribute> remainingAttributes)
	{
		this.examples = examples;
		this.attribute = attribute;
		this.edges = new ArrayList<Node>();
		this.edgeLabels = new ArrayList<String>();
		this.depth = 0;
		this.remainingAttributes = remainingAttributes;
	}
	
	
	public boolean getPluralityValue(String edgeLabel)
	{
		int noOfPositives = 0;
		int noOfNegatives = 0;
		
		ArrayList<Example> selectedExamples = new ArrayList<Example>();
		
		for(Example example : examples)
		{
			if(example.getAttributeValue(this.getAttribute()).equals(edgeLabel))
			{
				selectedExamples.add(example);
			}
		}
		
		for (Example example : selectedExamples)
		{
			if(example.classValue() == false)
			{
				noOfNegatives++;
			}
			else
			{
				noOfPositives++;
			}
		}
		
		if(selectedExamples.size() == 0)
		{
			noOfPositives = 0;
			noOfNegatives = 0;
			
			for (Example example : examples)
			{
				if(example.classValue() == false)
				{
					noOfNegatives++;
				}
				else
				{
					noOfPositives++;
				}
			}
		}
		
		if(noOfPositives > noOfNegatives)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	public boolean SingleClassification()
	{
		boolean classification = this.examples.get(0).classValue();
		
		for(Example example  : this.examples)
		{
			if(example.classValue() != classification)
				return false;
		}
		
		return true;
	}
	
	public static boolean SingleClassification(ArrayList<Example> examples)
	{
		boolean classification = examples.get(0).classValue();
		
		for(Example example  : examples)
		{
			if(example.classValue() != classification)
				return false;
		}
		
		return true;
	}
	

	public void prune(ArrayList<Node> e, ArrayList<String> el)
	{
		for(Node n : this.edges)
		{
			e.add(n);
		}
		
		for(String label : this.edgeLabels)
		{
			el.add(label);
		}
		
		this.edges.clear();
		this.edgeLabels.clear();
	}
	
	// SADECE INTERNAL NODE'lari RETURN ETMEN LAZIM
	
	public void addEdge(Node next, String label)
	{
		edges.add(next);
		edgeLabels.add(label);
		next.setParent(this);
		next.setDepth(this.depth+1);
		
	}

	public ArrayList<Example> getExamples() {
		return examples;
	}

	public Attribute getAttribute() {
		return attribute;
	}

	public ArrayList<Node> getEdges() {
		return edges;
	}

	public ArrayList<String> getEdgeLabels() {
		return edgeLabels;
	}

	public Node getParent() {
		return parent;
	}

	private void setParent(Node parent) {
		this.parent = parent;
		this.depth = parent.getDepth()+1;
	}
	
	public boolean isRoot()
	{
		if (this.parent == null)
			return true;
		
		return false;
	}
	
	public String toString()
	{
		String ret = "";
		if(this.isRoot())
		{
			ret = "Root\t";
		}
		else
		{
			
		}
		
		return ret;
	}
	

	public int getDepth() {
		return depth;
	}
	
	private void setDepth(int d) {
		this.depth = d;
	}
	
	public boolean isLeaf()
	{
		if(edges.size() == 0)
			return true;
		
		return false;
	}


	public ArrayList<Attribute> getRemainingAttributes() {
		return remainingAttributes;
	}


	public void setRemainingAttributes(ArrayList<Attribute> remainingAttributes) {
		this.remainingAttributes = remainingAttributes;
	}

}
